// File Locator.h
/*
  Un Locator e' un oggetto che ha associati un oggetto collezione (container)
  ed un oggetto (object) contenuto nella collezione. Il suo compito e'
  mantenere la posizione di object nel container.

  Tale posizione viene aggiornata dal container (che quindi deve accedere ai
  campi privati del locator).
*/

#ifndef LOCATOR_H
#define LOCATOR_H

class Locator
{friend class Heap;   //Heap deve aggiornare campi privati position e container
 public:
  Locator(int o, Heap& c, int p) {object = o; container = &c; position = p;}
  int Object(){return object;}
  Heap* Container(){return container;}
  int Position(){return position;}
 private:
  int object;
  Heap* container;
  int position;
};

#endif

