// File Heap.h
#ifndef HEAP_H
#define HEAP_H
#include "Locator.h"

struct elem {
  int key;
  Locator* loc;
};

class Heap
{public:
  Heap(int dimmax);                 //heap con dim massima dimmax
  ~Heap();
  bool EstVuoto();
  int DammiMax();                   // restituisce l'oggetto
  Locator* Inserisci(int o, int k); // restituisce il locator per ogg o nell'heap
  void EliminaMax();

 protected:
  elem* vett;                 // vettore di elem: la locazione 0 non e' usata
  int dim;                    // dimensione del vettore
  int n;                      // numero di elementi utilizzati nel vettore

  void FaiSalire(int pos);
  void FaiScendere(int pos);
  void Scambia(int pos1, int pos2);
  void Assegna(int pos1, int pos2);
  void Annulla(int pos);

 private:
  Heap(const Heap&);
  Heap& operator=(const Heap&);
};

#endif
