// File Heap.cpp
#include "Heap.h"
#include <iostream.h>


Heap::Heap(int dimmax)
{
  n = 0;
  dim = dimmax;
  vett = new elem[dim + 1];  //salta componente 0 per semplicita'
}

Heap::~Heap()
{
  for (int i = 1; i <= n; i++)
    vett[i].loc->container = NULL;
  delete [] vett;
}


// funzioni proprie dell' heap

bool Heap::EstVuoto()
{ return n == 0; }

int Heap::DammiMax()
{
  if (n == 0) return -1;
  return vett[1].loc->object;
}


Locator* Heap::Inserisci(int k, int o)
{
  if (n >= dim) return NULL;

  n++;
  Locator* l = new Locator(o,*this,n);
  vett[n].key = k;
  vett[n].loc = l;
  FaiSalire(n);
  return l;
}


void Heap::EliminaMax()
{
  if (n == 0) return;

  Annulla(1);
  Assegna(1,n);
  n--;
  FaiScendere(1);
}


void Heap::FaiSalire(int i)
{
  if (i > 1 && vett[i].key > vett[i/2].key) {
    Scambia(i,i/2);
    FaiSalire(i/2);
  }
}


void Heap::FaiScendere(int i)
{
  int largest;
  int sin = 2*i;
  int des = 2*i+1;
  if (sin <= n && vett[sin].key > vett[i].key)
    largest = sin;
  else largest = i;

  if (des <= n && vett[des].key > vett[largest].key)
    largest = des;

  if (largest != i) {
    Scambia(i,largest);
    FaiScendere(largest);
  }
}


void Heap::Scambia(int i, int j)
{
  elem temp = vett[i];
  vett[i] = vett[j];
  vett[j] = temp;
  vett[i].loc->position = i;
  vett[j].loc->position = j;
}


void Heap::Assegna(int i, int j)
{
  vett[i] = vett[j];
  vett[i].loc->position = i;
}

void Heap::Annulla(int i)
{ vett[i].loc->container = NULL; }
