#include "GestoreProcessi.h"
#include <iostream.h>

GestoreProcessi::GestoreProcessi(int dim) : Heap(dim)
{
 posizione = new Locator*[dim];
 for (int i = 0; i < dim ; i++) posizione[i] = NULL;
}

void GestoreProcessi::InCoda(int p, int k)
{
  if (EstInCoda(p)) return;
  Locator* l = Inserisci(p,k);
  if (posizione[p] != NULL) delete posizione[p];
  posizione[p] = l;
}

void GestoreProcessi::OutCoda(int p)
{
  if (!EstInCoda(p)) return;
  int i = posizione[p]->Position();
  if ((i < 1) || (i > n)) return;

  if (i == n) {
    Annulla(n);
    n--;
  }
  else {
    Annulla(i);
    Assegna(i,n);
    n--;
    FaiScendere(i);
  }
}

void GestoreProcessi::CambiaPriorita(int p, int nw)
{
  if (!EstInCoda(p)) return;
  int i = posizione[p]->Position();

  if ((i < 1) || (i > n)) return;

  int old = vett[i].key;
  vett[i].key = nw;
  if (nw == old)
    return;
  else if (nw < old) 
    FaiScendere(i);
  else  // (nw > old)
    FaiSalire(i);
}

bool GestoreProcessi::EstInCoda(int p)
{
  return posizione[p] != NULL && posizione[p]->Container() != NULL;
}
