// File Heap.h
#ifndef HEAP_H
#define HEAP_H

struct elem {
  int key;
  int obj;
};

class Heap
{public:
  Heap(int dimmax, int*& pos);        //heap con dim massima dimmax
                                      //vettore processi in sharing
  ~Heap();

  bool EstVuoto();
  int DammiMax();                      // restituisce l'oggetto
  void Inserisci(int k, int o);
  void EliminaMax();

 protected:
  elem* vett;                 // vettore di elem: la locazione 0 non e' usata
  int dim;                    // dimensione del vettore
  int n;                      // numero di elementi utilizzati nel vettore
  int*& posizione;             // posizione degli oggetti nel heap

  void FaiSalire(int pos);
  void FaiScendere(int pos);
  void Scambia(int pos1, int pos2);

 private:
  Heap(const Heap&);
  Heap& operator=(const Heap&);

};

#endif
