// File Heap.cpp
#include "Heap.h"


Heap::Heap(int dimmax, int*& pos) : posizione(pos) //vett posizione in sharing
{
  n = 0;
  dim = dimmax;
  vett = new elem[dim + 1];  //salta componente 0 per semplicita'
}

Heap::~Heap()
{
  for (int i = 1; i <= n; i++) posizione[i] = -1;
  delete [] vett;
}


// funzioni proprie dell' heap

bool Heap::EstVuoto()
{ return n == 0; }

int Heap::DammiMax()
{
  if (n == 0) return -1;
  return vett[1].obj;
}

void Heap::Inserisci(int k, int o)
{
  if (n >= dim) return;

  n++;
  vett[n].key = k;
  vett[n].obj = o;
  posizione[vett[n].obj] = n;
  FaiSalire(n);
}


void Heap::EliminaMax()
{
  if (n == 0) return;

  posizione[vett[1].obj] = -1;
  vett[1] = vett[n];
  posizione[vett[1].obj] = 1;
  n--;
  FaiScendere(1);
}


void Heap::FaiSalire(int i)
{
  if (i > 1 && vett[i].key > vett[i/2].key) {
    Scambia(i,i/2);
    FaiSalire(i/2);
  }
}


void Heap::FaiScendere(int i)
{
  int largest;
  int sin = 2*i;
  int des = 2*i+1;
  if (sin <= n && vett[sin].key > vett[i].key)
    largest = sin;
  else largest = i;

  if (des <= n && vett[des].key > vett[largest].key)
    largest = des;

  if (largest != i) {
    Scambia(i,largest);
    FaiScendere(largest);
  }
}


void Heap::Scambia(int i, int j)
{
  elem temp = vett[i];
  vett[i] = vett[j];
  vett[j] = temp;
  posizione[vett[i].obj] = i;
  posizione[vett[j].obj] = j;
}


