#include "GestoreProcessi.h"

GestoreProcessi::GestoreProcessi(int dim) : Heap(dim,posizione)
{
  posizione = new int[dim];
  for (int i = 0; i < dim ; i++) posizione[i] = -1;
}

void GestoreProcessi::InCoda(int p, int k)
{
  if (posizione[p] != -1) return;
  Inserisci(k,p);
}

void GestoreProcessi::OutCoda(int p)
{
  int i = posizione[p];
  if ((i < 1) || (i > n)) return;

  if (i == n) {
    posizione[vett[i].obj] = -1;
    n--;
  }
  else {
    posizione[vett[i].obj] = -1;
    vett[i] = vett[n];
    posizione[vett[i].obj] = i;
    n--;
    FaiScendere(i);
  }
}

void GestoreProcessi::CambiaPriorita(int p, int nw)
{
  int i = posizione[p];
  if ((i < 1) || (i > n)) return;

  int old = vett[i].key;
  vett[i].key = nw;
  if (nw == old)
    return;
  else if (nw < old) 
    FaiScendere(i);
  else  // (nw > old)
    FaiSalire(i);
}
