// File main_BFS_DFS.cpp

#include <iostream.h>
#include "GrafoLS.h"
#include "RecLis.h"

void BFSDistanza(Grafo&,int,int*);
void BFSCamminiMinimi(Grafo&,int,int*);
bool DFSRaggiungibile(Grafo& g, int, int);
RecLis* DFSCammino(Grafo& g, int, int);

void StampaDistruggi(RecLis* l)
{
  while (l!=NULL) {
    cout << l->info << " -> ";
    RecLis* aux = l;
    l = l->next;
    delete aux;
  }
  cout << "null";
  cout << endl;
}

void StampaCamminiMinimi(int i, int j, int* pred)
{
  if (i==j) cout << i;
  else {
    StampaCamminiMinimi(i,pred[j],pred);
    cout << " -> " << j;
  } 
}

void main()
{
  GrafoLS g(7);
  g.MettiArco(0,3);
  g.MettiArco(1,2);
  g.MettiArco(2,0);
  g.MettiArco(2,3);
  g.MettiArco(3,2);
  g.MettiArco(4,0);
  g.MettiArco(5,1);
  g.MettiArco(5,2);
  g.MettiArco(5,4);
  g.MettiArco(5,6);
  g.MettiArco(6,4);
  g.MettiArco(6,5);
  int rad = 5;

  //Calcolo delle distanze
  int * dist = new int[g.NumNodi()];
  BFSDistanza(g,rad,dist);
  for (int i = 0; i < g.NumNodi(); i++)
    cout << dist[i] << endl;
  cout << endl;

  //Calcolo dei cammini minimi
  int* pred = new int[g.NumNodi()];
  BFSCamminiMinimi(g,rad,pred);
  for (int j = 0; j < g.NumNodi(); j++) {
    cout << j << ": ";
    if (pred[j] != -1)
      StampaCamminiMinimi(rad,j,pred);
    cout << endl;
  }
  cout << endl;

  //Calcolo nodi raggiungibili
  for (int j = 0; j < g.NumNodi(); j++) {
    if (DFSRaggiungibile(g,rad,j))
      cout << j <<": raggiungibile\n";
    else cout << j <<": non raggiungibile\n";
  }
  cout << endl;

  //Calcolo nodi camminiraggiungibili
  for (int j = 0; j < g.NumNodi(); j++) {
    RecLis* l = DFSCammino(g,rad,j);
    StampaDistruggi(l);
  }
  cout << endl;

}


