// File mainEsp.cpp

#include <iostream.h>
#include "GrafoLS.h"
#include "EspBFSDistanza.h"
#include "EspBFSCamminiMinimi.h"
#include "EspDFSRagg.h"


void StampaCamminiMinimi(int i, int j, int* pred)
{
  if (i==j) cout << i;
  else {
    StampaCamminiMinimi(i,pred[j],pred);
    cout << " -> " << j;
  } 
}

void main()
{
  GrafoLS g(7);
  g.MettiArco(0,3);
  g.MettiArco(1,2);
  g.MettiArco(2,0);
  g.MettiArco(2,3);
  g.MettiArco(3,2);
  g.MettiArco(4,0);
  g.MettiArco(5,1);
  g.MettiArco(5,2);
  g.MettiArco(5,4);
  g.MettiArco(5,6);
  g.MettiArco(6,4);
  g.MettiArco(6,5);
  int rad = 5;

  // Calcola distanze minime
  int * distanze = new int[g.NumNodi()];
  Distanza(g,rad,distanze);
  for (int i = 0; i<g.NumNodi(); i++)
    cout << distanze[i] <<endl;
  cout << endl;

  //Calcola cammini minimi
  int* pred = new int[g.NumNodi()];
  CamminiMinimi(g,rad,pred);
  for (int j = 0; j < g.NumNodi(); j++) {
    cout << j << ": ";
    if(pred[j] != -1) StampaCamminiMinimi(rad,j,pred);
    cout << endl;
  }
  cout << endl;

  //Calcola nodi raggiungibili
  for (int dest = 0; dest < g.NumNodi(); dest++)
    if (Raggiungibile(g,rad,dest))
      cout << dest << " e' raggiungibile da " << rad << endl;
    else cout << dest << " non e' raggiungibile da " << rad << endl;
    cout << endl;
}






