// File IteratoreLS.h

#ifndef ITERATORE_LS_H
#define ITERATORE_LS_H
#include "Iteratore.h"
#include "GrafoLS.h"

class IteratoreLS : public Iteratore
{public:

  IteratoreLS(GrafoLS& g, int n)
  {
    grafo = &g;
    nodo = n;
    nxt = grafo->succ[nodo];
  }

  bool HasNext()
  { return nxt != NULL; }

  int  Next()
  {
    int n = nxt->info;
    nxt = nxt->next;
    return n;
  }

  void Reset() { nxt = grafo->succ[nodo]; }

 private:
  rec* nxt;
  GrafoLS* grafo;
  int nodo;
};

#endif;


/*
  Uso:
  Iteratore* GrafoLS::Successori(int i)
  { return new IteratoreLS(*this,i); }
*/
