// File GrafoLS.h

#ifndef GRAFO_LS_H
#define GRAFO_LS_H
#include "Grafo.h"

struct rec {
  int info;
  rec* next;
};

class GrafoLS : public Grafo
{friend class IteratoreLS;
 public:
  GrafoLS(int num);
  ~GrafoLS();
  GrafoLS(const GrafoLS&);
  GrafoLS& operator=(const GrafoLS&);
  int NumNodi();
  void MettiArco(int, int);
  void TogliArco(int, int); 
  bool EsisteArco(int, int);
  Iteratore* Successori(int);
 private:
  int nodi;
  rec** succ;
  rec** pred;
  static rec* Copia(rec*);
  static void Cancella(rec*);
  static bool Appartiene(rec*,int);
  static void Elimina(rec*&,int);
};

#include "IteratoreLS.h"

#endif
