// File EspDFS.h

#ifndef ESP_DFS_H
#define ESP_DFS_H
#include "Marca.h"
#include "Grafo.h"

class EspDFS : public Marca
{public:
  EspDFS(Grafo& g) : Marca(g.NumNodi()) { gr = &g; }
  virtual void InizioVisita() = 0;
  virtual void FineVisita() = 0;
  virtual void PreVisita(int) = 0;
  virtual void PostVisita(int) = 0;  
  virtual bool Stop() = 0;
  Grafo* Gr() { return gr; }
 protected:
  Grafo* gr;
};

void DFS(EspDFS&,int);
void MainDFS(EspDFS&,int);

#endif



