// File EspBFSDistanza.h

#ifndef ESP_BFS_DISTANZA_H
#define ESP_BFS_DISTANZA_H
#include "EspBFS.h"
#include <iostream.h>

class EspBFSDistanza : public EspBFS
{public:
  EspBFSDistanza(Grafo& g, int* odist) : EspBFS(g){ dist = odist; }
  void InizioVisita(){ for (int i=0; i<gr->NumNodi();i++) dist[i] = -1; }
  void FineVisita(){}
  void PreVisita(int j,int i)
  { 
    if (i==-1) dist[j] = 0;
    else {
      dist[j]=dist[i]+1; 
      cout << i <<": "<<dist[i] << "->" << j <<": "<<dist[j] << endl;
    }
  }
  void PostVisita(int i){}
  bool Stop() {return false;}
 protected:
  int* dist;
};

void Distanza (Grafo& g, int i, int* odist)
{
  EspBFSDistanza esp(g,odist);
  BFS(esp,i);
}

#endif
