// File EspBFS.h

#ifndef ESP_BFS_H
#define ESP_BFS_H
#include "Marca.h"
#include "Coda.h"
#include "Grafo.h"

class EspBFS : public Marca, public Coda<int>
{public:
  EspBFS(Grafo& g) : Marca(g.NumNodi()) { gr = &g; }
  virtual void InizioVisita() = 0;
  virtual void FineVisita() = 0;
  virtual void PreVisita(int,int) = 0;
  virtual void PostVisita(int) = 0;
  virtual bool Stop() = 0;
  Grafo* Gr() { return gr; }
 protected:
  Grafo* gr;
};

void BFS(EspBFS&,int);

#endif
