// File DFSRaggiungibile.cpp

// Calcola se un dato nodo dest e' raggiungibile da un nodo rad

#include <iostream.h>
#include "Grafo.h"

void DFSRag(Grafo& g, int i, int dest, bool* marca, bool& trovato)
{
  //Per interrompere la visita
  if (trovato) return;

  marca[i] = true;

  //PreVisita di i: inizia la visita di i (i diviene "grigio")
  if (i==dest) {
    trovato = true; return;
  }

  Iteratore* itr = g.Successori(i);
  while (itr->HasNext()) {
    int j = itr->Next();
    if (!marca[j])
      DFSRag(g,j,dest,marca,trovato);
  }
  delete itr;
  //PostVisita di i: termina la visita di i (i diviene "nero")
  //niente
}

bool DFSRaggiungibile(Grafo& g, int rad, int dest)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  //InizioVisita: inizia la visita del grafo
  bool trovato = false;

  DFSRag(g,rad,dest,marca,trovato);


  delete[] marca;
  //FineVisita: la visita del grafo e' terminata
  return trovato;
}
