// File DFSCammino.cpp

// Calcola, se esiste, un cammino tra il nodo rad e il nodo dest e lo
// restituisce in una lista, fa uso di record uguali del tipo (uguali a quelli
// usati per la lista di successori
//
//   struct rec* {
//     int info;
//     rec* next;
//   };
//

#include <iostream.h>
#include "Grafo.h"
#include "RecLis.h"


void DFSCamm(Grafo& g, int i, int dest, bool* marca, bool& trovato, RecLis*& l)
{
  //Per interrompere la visita
  if (trovato) return;

  marca[i] = true;

  //PreVisita di i: inizia la visita di i (i diviene "grigio")
  if (i==dest)
    trovato = true;


  Iteratore* itr = g.Successori(i);
  while (itr->HasNext()) {
    int j = itr->Next();
    if (!marca[j])
      DFSCamm(g,j,dest,marca,trovato,l);
  }
  delete itr;
  //PostVisita di i: termina la visita di i (i diviene "nero")
  if (trovato) {
    RecLis* aux = new RecLis;
    aux->info = i;
    aux->next = l;
    l = aux;
  }
}

RecLis* DFSCammino(Grafo& g, int rad, int dest)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  //InizioVisita: inizia la visita del grafo
  bool trovato = false;
  RecLis* ris = NULL;

  DFSCamm(g,rad,dest,marca,trovato,ris);


  delete[] marca;
  //FineVisita: la visita del grafo e' terminata
  return ris;
}
