// File ChiusuraTransitiva.cpp

// Calcola la chiusura transitiva di un grafo

#include <iostream.h>
#include "Grafo.h"


void DFSPCT(Grafo& g, int i, bool* marca, int rad, Grafo& gg)
{

  marca[i] = true;

  //PreVisita di i: inizia la visita di i (i diviene "grigio")
  gg.MettiArco(rad,i);


  Iteratore* itr = g.Successori(i);
  while (itr->HasNext()) {
    int j = itr->Next();

    //va inoltre aggiunto
    if (j==rad) gg.MettiArco(rad,rad); //nota anche se marcato

    if (!marca[j])
      DFSPCT(g,j,marca,rad,gg);
  }
  delete itr;
  //PostVisita di i: termina la visita di i (i diviene "nero")
  //niente

}

void DFSPassoChiusuraTransitiva(Grafo& g, int rad, Grafo& gg)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  //InizioVisita: inizia la visita del grafo
  //niente

  DFSPCT(g,rad,marca,rad,gg);

  //FineVisita: la visita del grafo e' terminata
  //niente

  delete[] marca;
}


void ChiusuraTransitiva(Grafo& g, Grafo& gg)
{//inizialmente gg e' una copia di g
  for (int i = 0; i < g.NumNodi(); i++)
    DFSPassoChiusuraTransitiva(g,i,gg);

}
