// File BFSDistanza.cpp
// Calcola la distanza minima di tutti i nodi da un nodo rad

#include <iostream.h>
#include "Grafo.h"
#include "Coda.h"

void BFSDistanza(Grafo& g, int rad, int* dist)
{ // dist e' un vett in sharing dove vengono restituite le distanze
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;
  Coda<int> c;

  //InizioVisita: inizia la visita del grafo
  for (int i = 0; i < g.NumNodi(); i++)
    dist[i] = -1;

  marca[rad] = true;

  //PreVisita di rad: inizia la visita di rad (rad diviene "grigio" -cfr. clr)
  dist[rad] = 0;

  c.InCoda(rad);

  while (!c.EstVuota()) {
    int i = c.Primo(); c.OutCoda();
    Iteratore* itr = g.Successori(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;

        //PreVisita di j: inizia la visita di j (j diviene "grigio")
        dist[j] = dist[i] + 1;

        c.InCoda(j);
      }
    }
    delete itr;
    //PostVisita di i: termina la visita di i (i diviene "nero")
    //niente
  }

  //FineVisita: la visita del grafo e' terminata
  //niente
  delete[] marca;
}
