// File VisitaProfonditaPila.cpp
// Visita in Profondita' (DFS) con uso di una pila

/*

  Si noti nella versione con uso di una pila di Visita in Profondita', quando
  la visita di un nodo termina, e' iniziata (ma non terminata) la visita dei
  suoi successori

  Invece nella versione ricorsiva di Visita in Profondita', quando la visita di
  un nodo termina, e' gia' terminata anche la visita dei suoi successori

  Questa e' una distinzione importante in certi casi, e rende preferibile la
  versione ricorsiva.

*/

#include <iostream.h>
#include "Grafo.h"
#include "Pila.h"


void VisitaProfonditaPila(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;
  Pila<int> p;

  //InizioVisita: inizia la visita del grafo
  cout << "Inizia la visita del grafo\n";

  marca[rad] = true;
  //PreVisita di rad: inizia la visita di rad (rad diviene "grigio" -cfr. clr)
  cout << "inizio visita nodo: " << rad << endl;
  p.Push(rad);

  while (!p.EstVuota()) {
    int i = p.Top(); p.Pop();
    Iteratore* itr = g.Successori(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;
        //PreVisita di j: inizia la visita di j (j diviene "grigio")
        cout << "inizio visita nodo: " << j << endl;
        p.Push(j);
      }
    }
    delete itr;
    //PostVisita di i: termina la visita di i (i diviene "nero")
    cout << "fine visita nodo: " << i << endl;
  }

  //FineVisita: la visita del grafo e' terminata
  cout << "La visita del grafo e' terminata\n";

  delete[] marca;
}
