// File VisitaProfondita0.cpp
// Visita in Profondita' (DFS) ricorsiva - versione preliminare

/*

  Si noti nella versione ricorsiva di Visita in Profondita', quando la visita
  di un nodo termina, e' gia' terminata anche la visita dei suoi successori

  Invece nella versione di Visita in Profondita' con la Pila, quando la visita
  di un nodo termina, e' iniziata (ma non terminata) la visita dei suoi
  successori

  Questa e' una distinzione importante in certi casi, e rende preferibile la
  versione ricorsiva.

*/

#include <iostream.h>
#include "Grafo.h"

void VisitaSuccessori(Grafo& g, int i, bool* marca)
{
  Iteratore* itr = g.Successori(i);
  while (itr->HasNext()) {
    int j = itr->Next();
    if (!marca[j]) {
      marca[j] = true;
      //PreVisita di j: inizia la visita di j (j diviene "grigio")
      cout << "inizio visita nodo: " << j << endl;
      VisitaSuccessori(g,j,marca);
      //PostVisita di j: termina la visita di j (j diviene "nero")
      cout << "fine visita nodo: " << j << endl;
    }
  }
  delete itr;
}

void MainVisitaProfondita0(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  //InizioVisita: inizia la visita del grafo
  cout << "Inizia la visita del grafo\n";

  marca[rad] = true;
  //PreVisita di rad: inizia la visita di rad (rad diviene "grigio" -cfr. clr)
  cout << "inizio visita nodo: " << rad << endl;
  VisitaSuccessori(g,rad,marca);
  //PostVisita di rad: termina la visita di rad (rad diviene "nero")
  cout << "fine visita nodo: " << rad << endl;

  //FineVisita: la visita del grafo e' terminata
  cout << "La visita del grafo e' terminata\n";

  delete[] marca;
}
