// File VisitaProfondita.cpp
// Visita in Profondita' (DFS) ricorsiva - versione finale

/*

  Si noti nella versione ricorsiva di Visita in Profondita', quando la visita
  di un nodo termina, e' gia' terminata anche la visita dei suoi successori

  Invece nella versione di Visita in Profondita' con la Pila, quando la visita
  di un nodo termina, e' iniziata (ma non terminata) la visita dei suoi
  successori

  Questa e' una distinzione importante in certi casi, e rende preferibile la
  versione ricorsiva.

*/

#include <iostream.h>
#include "Grafo.h"

void VisitaProfondita(Grafo& g, int i, bool* marca)
{
  marca[i] = true;
  //PreVisita di i: inizia la visita di i (i diviene "grigio")
  cout << "inizio visita nodo: " << i << endl;
  Iteratore* itr = g.Successori(i);
  while (itr->HasNext()) {
    int j = itr->Next();
    if (!marca[j])
      VisitaProfondita(g,j,marca);
  }
  delete itr;
  //PostVisita di i: termina la visita di i (i diviene "nero")
  cout << "fine visita nodo: " << i << endl;
}

void MainVisitaProfondita(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  //InizioVisita: inizia la visita del grafo
  cout << "Inizia la visita del grafo\n";

  VisitaProfondita(g,rad,marca);

  //FineVisita: la visita del grafo e' terminata
  cout << "La visita del grafo e' terminata\n";

  delete[] marca;
}
