// File Visita.cpp

#include <iostream.h>
#include "GrafoLS.h"
#include "Coda.h"
#include "Pila.h"


//calcolo delle distanze
int* Distanze(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;
  Coda<int> c;

  //InizioVisita
  dist = new int[g.NumNodi()]
  for (int i = 0; i < g.NumNodi(); i++)
    dist[i] = -1;

  marca[rad] = true;
  //PreVisita di rad
  dist[rad] = 0;
  c.InCoda(rad);

  while (!c.EstVuota()) {
    int i = c.Primo();
    Iterator* itr = g.Successori(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;
        //PreVisita di j
        dist[j] = dist[i]+1;
        c.InCoda(j);
      }
    }
    delete itr;
    //PostVisita di i
    c.OutCoda();
  }
  //FineVisita
  return dist;
}




bool Reachability(Grafo& g, int rad, int dest)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;
  Pila<int> p;

  // InizioVisita

  marca[rad] = true;
  // PreVisita di rad
  if (rad == dest) return true;
  p.Push(rad);

  while (!p.EstVuota()) {
    int i = p.Top();
    Iterator* itr = g.Successori(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;
        //PreVisita di j
        if (j == dest) return true;
        p.Push(j);
      }
    }
    delete itr;
    //PostVisita di i
    p.Pop();
  }
  //FineVisita
  return false;
}



// chiusura transitiva
void PassoChiusuraTransitiva(Grafo& g, int rad, Grafo& gg)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;
  Pila<int> p;

  //InizioVisita

  marca[rad] = true;
  //PreVisita di rad
  gg.AggiungiArco(rad,rad);
  p.Push(rad);

  while (!p.EstVuota()) {
    int i = p.Top();
    Iterator* itr = g.Successori(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;
        //PreVisita di j
        gg.AggiungiArco(rad,j);
        p.Push(j);
      }
    }
    delete itr;
    //PostVisita di i
    p.Pop();
  }
  //FineVisita()
}

void ChiusuraTransitiva(Grafo& g, Grafo&gg)
{ // gg e' inizialmente una copia di g
  for (int i = 0; i < g.NumNodi(); i++)
    PassoChiusuraTransitiva(g,i,gg);
}


// trova cammino
static void Visita(int i, int goal, Grafo& g, bool* marca,
{
  //Visita
  Iterator* itr = g.Successori(i);
  while (itr->HasNext()) {
    int j = itr->Next();
    if (!marca[j]) {
      marca[j] = true;
      //PreVisita(i)
      res = new rec;
      res->info = j;
      Visita(j,goal,g,marca,primo,res->next,path);
      //PostVisita(i)
      delete res;
      }
    }
  delete itr;
}

static void Visita(Grafo& g, int i, bool* marca
                   rec* primo, rec*& res, rec* path)
{
  marca[i] = true;

  //PreVisita di i
  if (path != NULL) return;
  else if (i == goal) {
    res = NULL;
    path = copia(primo);
    return;
  }
  else {
    res = new rec;
    res->info = i;
  }

  Iteratore* itr = g.Successori(i);
  while (itr->HasNext()) {
    int j = itr->Next();
    if (!marca[j])
      Visita(g,j,marca);
  }
  delete itr;
  //PostVisita di i
  delete res;
}

rec* Path(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  //InizioVisita
  rec* path = NULL;
  rec* primo;

  Visita(g,rad,marca,primo,primo,path);

  //FineVisita
  return path;
}


