// File VisitaAmpiezza.cpp
// Visita in Ampiezza (BFS) - fa uso di una coda

#include <iostream.h>
#include "Grafo.h"
#include "Coda.h"

void VisitaAmpiezza(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;
  Coda<int> c;

  //InizioVisita: inizia la visita del grafo
  cout << "Inizia la visita del grafo\n";

  marca[rad] = true;
  //PreVisita di rad: inizia la visita di rad (rad diviene "grigio" -cfr. clr)
  cout << "inizio visita nodo: " << rad << endl;
  c.InCoda(rad);

  while (!c.EstVuota()) {
    int i = c.Primo(); c.OutCoda();
    Iteratore* itr = g.Successori(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;
        //PreVisita di j: inizia la visita di j (j diviene "grigio")
        cout << "inizio visita nodo: " << j << endl;
        c.InCoda(j);
      }
    }
    delete itr;
    //PostVisita di i: termina la visita di i (i diviene "nero")
    cout << "fine visita nodo: " << i << endl;
  }

  //FineVisita: la visita del grafo e' terminata
  cout << "La visita del grafo e' terminata\n";

  delete[] marca;
}
