// File IteratoreMA.h

#ifndef ITERATORE_MA_H
#define ITERATORE_MA_H
#include "Iteratore.h"
#include "GrafoMA.h"


class IteratoreMA : public Iteratore
{public:

  IteratoreMA(GrafoMA& g, int n)
  {
    grafo = &g;
    nodo = n;
    start  = 0;
    while (!grafo->matrice[nodo][start] && start < grafo->nodi)
      start++;
    nxt = start;
  }

  bool HasNext() { return nxt < grafo->nodi; }

  int Next()
  {
    if (nxt == grafo->nodi) return -1;
    else {
      int n = nxt;
      do
        nxt++;
      while (!grafo->matrice[nodo][nxt] && nxt < grafo->nodi);
      return n;
    }
  }

  void Reset(){ nxt = start; }

 private:
  int nxt;
  int start;
  int nodo;
  GrafoMA* grafo;
};

#endif;
