// File GrafoMA.cpp
#include <iostream.h>
#include "GrafoMA.h"

GrafoMA::GrafoMA(int num)
{ nodi = num;

  matrice = new bool*[nodi];
  for (int i = 0; i < nodi; i++)
    matrice[i] = new bool[nodi];

  for (int i = 0; i < nodi; i++)
    for (int j = 0; j < nodi; j++)
      matrice[i][j] = false;
}

GrafoMA::~GrafoMA()
{ Cancella(matrice,nodi); }

GrafoMA::GrafoMA(const GrafoMA& g)
{
  nodi = g.nodi;
  matrice = Copia(g.matrice,nodi);
}

GrafoMA& GrafoMA::operator=(const GrafoMA& g)
{ if (this != &g) {
    Cancella(matrice,nodi);
    nodi = g.nodi;
    matrice = Copia(g.matrice,nodi);
  }
  return *this;
}

int GrafoMA::NumNodi() 
{ return nodi; }

void GrafoMA::MettiArco(int i, int j)
{ matrice[i][j] = true; }

void GrafoMA::TogliArco(int i, int j) 
{ matrice[i][j] = false; }

bool GrafoMA::EsisteArco(int i, int j) 
{ return matrice[i][j]; }

Iteratore*  GrafoMA::Successori(int i)
{ return new IteratoreMA(*this,i); }

bool** GrafoMA::Copia(bool** mat, int n)
{
  bool** ris = new bool*[n];
  for (int i = 0; i < n; i++)
    ris[i] = new bool[n];

  for (int i = 0; i < n; i++)
    for (int j = 0; j < n; j++)
      ris[i][j] = mat[i][j];
}

void GrafoMA::Cancella(bool** mat, int n)
{ for (int i = 0; i < n; i++)
    delete [] mat[i];
  delete [] mat;
}

