// File Visita.cpp

#include <iostream.h>
#include "GrafoLS.h"
#include "Coda.h"
#include "Pila.h"

//#include "VisitaNodo.h"
// contiene void VisitaNodo(Grafo&, int);
// che specifica cio' che si fa sul nodo visitato

//Es di aggiorna
void VisitaNodo(Grafo& g, int n)
{ cout << n << ' '; }

void VisitaAmpiezza(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  Coda<int> c;
  marca[rad] = true;
  c.InCoda(rad);

  while (!c.EstVuota()) {
    int i = c.Primo(); c.OutCoda();
    VisitaNodo(g,i);
    Iteratore* itr = g.Successori(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;
        c.InCoda(j);
      }
    }
    delete itr;
  }
}


void VisitaProfondita(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  Pila<int> p;
  marca[rad] = true;
  p.Push(rad);

  while (!p.EstVuota()) {
    int i = p.Top(); p.Pop();
    VisitaNodo(g,i);
    Iteratore* itr = g.Successori(i);
    while (itr->HasNext()) {
      int j = itr->Next();
      if (!marca[j]) {
        marca[j] = true;
        p.Push(j);
      }
    }
    delete itr;
  }
}



static void Visita(int i, Grafo& g, bool* marca)
{
  VisitaNodo(g,i);
  Iteratore* itr = g.Successori(i);
  while (itr->HasNext()) {
    int j = itr->Next();
    if (!marca[j]) {
      marca[j] = true;
      Visita(j,g,marca);
      }
    }
  delete itr;
}

void VisitaProfonditaR(Grafo& g, int rad)
{
  bool* marca = new bool[g.NumNodi()];
  for (int i = 0; i < g.NumNodi(); i++)
    marca[i] = false;

  marca[rad] = true;
  Visita(rad,g,marca);
}




