// File GrafoMA.cpp
#include "GrafoMA.h"
#include <iostream.h>

// Funzioni di IteratoreMA


IteratoreMA::IteratoreMA(GrafoMA& g, int n, bool sp)
{
  grafo = &g;
  nodo = n;
  succ_pred = sp;
  start = 0;
  while (!mat(nodo,start) && start < grafo->nodi)
    start++;
  nxt = start;
}

bool IteratoreMA::HasNext()
{ return nxt < grafo->nodi; }

int IteratoreMA::Next()
{
  if (nxt == grafo->nodi) return -1;
  else {
    int n = nxt;
    do
      nxt++;
    while (!mat(nodo,nxt) && nxt < grafo->nodi);
    return n;
  }
}

void IteratoreMA::Reset()
{ nxt = start; }

bool  IteratoreMA::mat(int i, int j)
{
  if (succ_pred) return grafo->matrice[i][j];
  else /*pred*/  return grafo->matrice[j][i];
}




// Funzioni di GrafoMA

GrafoMA::GrafoMA(int num)
{ nodi = num;

  matrice = new bool*[nodi];
  for (int i = 0; i < nodi; i++)
    matrice[i] = new bool[nodi];

  for (int i = 0; i < nodi; i++)
    for (int j = 0; j < nodi; j++)
      matrice[i][j] = false;
}

GrafoMA::~GrafoMA()
{ Cancella(matrice,nodi); }

GrafoMA::GrafoMA(const GrafoMA& g)
{
  nodi = g.nodi;
  matrice = Copia(g.matrice,nodi);
}

GrafoMA& GrafoMA::operator=(const GrafoMA& g)
{ if (this != &g) {
    Cancella(matrice,nodi);
    nodi = g.nodi;
    matrice = Copia(g.matrice,nodi);
  }
  return *this;
}

int GrafoMA::NumNodi() 
{ return nodi; }

void GrafoMA::MettiArco(int i, int j)
{ matrice[i][j] = true; }

void GrafoMA::TogliArco(int i, int j) 
{ matrice[i][j] = false; }

bool GrafoMA::EsisteArco(int i, int j) 
{ return matrice[i][j]; }

Iteratore*  GrafoMA::Successori(int i)
{ return new IteratoreMA(*this,i,true); }

Iteratore*  GrafoMA::Predecessori(int i)
{ return new IteratoreMA(*this,i,false); }

bool** GrafoMA::Copia(bool** mat, int n)
{
  bool** ris = new bool*[n];
  for (int i = 0; i < n; i++)
    ris[i] = new bool[n];

  for (int i = 0; i < n; i++)
    for (int j = 0; j < n; j++)
      ris[i][j] = mat[i][j];
}

void GrafoMA::Cancella(bool** mat, int n)
{ for (int i = 0; i < n; i++)
    delete [] mat[i];
  delete [] mat;
}

