// File GrafoLS.cpp
#include <iostream.h>
#include "GrafoLS.h"

// funzioni di IteratoreLS

IteratoreLS::IteratoreLS(GrafoLS& g, int n, bool b)
{
  grafo = &g;
  nodo = n;
  succ_pred = b;
  if (succ_pred) nxt = grafo->succ[nodo];
  else nxt = grafo->pred[nodo];
}
bool IteratoreLS::HasNext()
{ return nxt != NULL; }

int  IteratoreLS::Next()
{
  int ris = nxt->info;
  nxt = nxt->next;
  return ris;
}

void IteratoreLS::Reset()
{
  if (succ_pred) nxt = grafo->succ[nodo];
  else nxt = grafo->pred[nodo];
}


// funzioni di GrafoLS


GrafoLS::GrafoLS(int num)
{ 
  nodi = num;
  succ = new rec*[nodi];
  pred = new rec*[nodi];
  for (int i = 0; i < nodi; i++) {
    succ[i] = NULL;
    pred[i] = NULL;
  }
}

GrafoLS::~GrafoLS() 
{ 
  for (int i = 0; i < nodi; i++) {
    Cancella(succ[i]);
    Cancella(pred[i]);
  }
  delete [] succ;
  delete [] pred;
}

GrafoLS::GrafoLS(const GrafoLS& g)
{
  nodi = g.nodi;
  succ = new rec*[nodi];
  pred = new rec*[nodi];
  for (int i = 0; i < nodi; i++) {
    succ[i] = Copia(g.succ[i]);
    pred[i] = Copia(g.pred[i]);
  }
}

GrafoLS& GrafoLS::operator=(const GrafoLS& g)
{
  if (this != &g) {
    for (int i = 0; i < nodi; i++) {  //cancella strutture preesistenti
      Cancella(succ[i]);
      Cancella(pred[i]);
    }
    delete [] succ;
    delete [] pred;
    nodi = g.nodi;                   //copia nuove strutture
    succ = new rec*[nodi];
    pred = new rec*[nodi];
    for (int i = 0; i < nodi; i++) {
      succ[i] = Copia(g.succ[i]);
      pred[i] = Copia(g.pred[i]);
    }
    return *this;
  }
}

int GrafoLS::NumNodi()
{ return nodi; }

void GrafoLS::MettiArco(int i, int j) 
{ 
  if (!Appartiene(succ[i],j)) {
    rec* tmp1 = new rec;
    tmp1->info = j;
    tmp1->next = succ[i];
    succ[i] = tmp1;

    rec* tmp2 = new rec;
    tmp2->info = i;
    tmp2->next = pred[j];
    pred[j] = tmp2;
  }
}

void GrafoLS::TogliArco(int i, int j) 
{
  Elimina(succ[i],j);
  Elimina(pred[j],i);
}

bool GrafoLS::EsisteArco(int i, int j)
{ return Appartiene(succ[i],j); }

Iteratore* GrafoLS::Successori(int i)
{ return new IteratoreLS(*this,i,true); }

Iteratore* GrafoLS::Predecessori(int i)
{ return new IteratoreLS(*this,i,false); }


rec* GrafoLS::Copia(rec* l)
{
  if (l==NULL) return NULL;
  else {
    rec* ris = new rec;
    ris->info = l->info;
    ris->next = Copia(l->next);
    return ris;
  }
}

void GrafoLS::Cancella(rec* l)
{
  while (l!=NULL) {
    rec* tmp = l;
    l = l->next;
    delete tmp;
  }
}

bool GrafoLS::Appartiene(rec* l, int n)
{ return (l != NULL) && ((l->info == n) || Appartiene(l->next,n)); }

void GrafoLS::Elimina(rec*& l, int n)
{
  if (l!=NULL) {
    if (l->info == n) {
      rec* tmp = l;
      l=l->next;
      delete tmp;
    }
    else Elimina(l->next, n);
  }
}
