// File Coda.cpp
#include "Coda.h"

template <class Tipo>
Coda<Tipo>::Coda()
{ front = NULL;
  back = NULL;
}

template <class Tipo>
Coda<Tipo>& Coda<Tipo>::operator=(const Coda<Tipo>& c)
{ if (this == &c) return *this;
  item<Tipo>* pt = front;
  front = Copia(c.front);
  Distruggi(pt);
}

template <class Tipo>
Coda<Tipo>::Coda(const Coda<Tipo>& c)
{  front = Copia(c.front); }

template <class Tipo>
void Coda<Tipo>::InCoda(Tipo elem)
{ item<Tipo>* pt = new item<Tipo>;
  pt->val = elem;
  pt->next = NULL;
  if (front == NULL) 
    { front = pt;
      back = pt;
    }
  else
    { back->next = pt;
      back = pt;
    }
}

template <class Tipo>
void Coda<Tipo>::OutCoda()
{ item<Tipo>* pt = front;
  front = front->next;
  delete pt;
}

template <class Tipo>
void Coda<Tipo>::Distruggi(item<Tipo>* pt)
{ if (pt != NULL)
    { Distruggi(pt->next);
      delete pt;
    }
}
    
template <class Tipo>
item<Tipo>* Coda<Tipo>::Copia(item<Tipo>* p)
{ if (p != NULL)
    { item<Tipo>* q = new item<Tipo>;
      q->val = p->val;
      q->next = Copia(p->next);
      return q;
    }
  else return NULL;
}
