// File greedy-risorsa.h
#ifndef GREEDY_RISORSA_H
#define GREEDY_RISORSA_H
#include "esp-greedy.h"
#include "MergeSort.h"


class elem
{public:
  int fine;
  int indice;
  bool operator<(elem e) {return fine < e.fine;}
};

class EspGreedyRisorsa : public EspGreedy
{public:

  EspGreedyRisorsa(int in, int* iin, int* ifi, bool* or);
  ~EspGreedyRisorsa();

  void PreparaRicerca();
  void PrimoStadio();
  void ProssimoStadio();
  bool SoluzioneCompleta();
  void ScegliStadioCorrente();
  void OutputRisposta();

 private:
  int n;
  int* inizio;
  int* fine;
  bool* ris;

  elem* vett;

  int stadio;
  int fine_ultima_scelta;

  EspGreedyRisorsa(EspGreedyRisorsa&);
  EspGreedyRisorsa& operator=(EspGreedyRisorsa&);
};






void RisolviGreedyRisorsa(int in, int* iin, int* ifi, bool* or);

#endif
