// File greedy-bisaccia.h
#ifndef GREEDY_BISACCIA_H
#define GREEDY_BISACCIA_H
#include "esp-greedy.h"
#include "MergeSort.h"


class elem
{public:
  double p_su_c;
  int indice;
  bool operator<(elem e) {return p_su_c > e.p_su_c;}
};

class EspGreedyBisaccia : public EspGreedy
{public:

  EspGreedyBisaccia(int in, int* ip, int* ic, int ib, int* or);
  ~EspGreedyBisaccia();

  void PreparaRicerca();
  void PrimoStadio();
  void ProssimoStadio();
  bool SoluzioneCompleta();
  void ScegliStadioCorrente();
  void OutputRisposta();

 private:
  int n;
  int* profitti;
  int* costi;
  int budget;
  int* ris;

  elem* vett;

  int stadio;

  EspGreedyBisaccia(EspGreedyBisaccia&);
  EspGreedyBisaccia& operator=(EspGreedyBisaccia&);
};





void RisolviGreedyBisaccia(int in, int* ip, int* ic, int ib, int* or);

#endif
