// File: hashingStringhe.cpp

/* 
   Mostra due tipici esempi di funzioni per trasformare stringhe in interi 
   in modo da poter applicare successivamente una funzione di hashing standard 
   su interi, quale (K mod dimTavola).
*/

// ris(k) = k[0] + k[1] + k[2] + .. + k[n] 
// nota k[i] int cod. ascii 
int hashStringa1(char* key)
{
  int ris = 0;
  int i = 0;
  while (key[i] != '\0') {
    ris = ris + key[i];
    i++;
  }
  return ris; 
}



// ris(k) = (..((k[0]*31 + k[1])*31 + k[2]*31)..)+k[n])
// nota k[i] int cod. ascii 
// Questa trasformazione e' simile a quella usata della funz di hashing 
// per stringhe predefinita in Java
int hashStringa2(char* key)
{
  int ris = 0;
  int i = 0;
  while (key[i] != '\0') {
    ris = ris*31 + key[i]; 
    i++;
  }
  return (ris > 0? ris : -ris); // ris < 0 in caso di overflow
}

//---------------------------------------------------------------------//
// File: prova.cpp

#include <iostream.h>

// programma di prova
void main()
{
  cout << hashStringa1("pippo") << endl;  
  cout << hashStringa1("topolino") << endl;
  cout << hashStringa1("paperino") << endl;
  cout << hashStringa1("paperina") << endl;
  cout << hashStringa1("qui") << endl;  
  cout << hashStringa1("quo") << endl;
  cout << hashStringa1("qua") << endl;

  cout << hashStringa1("qqqqqqqqqqqqwwwwwwwwwwwwwwwwwwwwwwwuuuuuuuuuuuuuuuushggggggggggggmmmmmmmmmmmmmmmkkkkkkkkkkkkkkkkrrrrrrrrrrrrrrrrrrrrrrrrrrrrooooooooooooooooooooooooooosddddddddddddddddddslllllllllllllllllllllaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaammmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmgggggggggggggggggggggggggggmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmaaaaaaaaaaaaaaaaaaaaaaaaaaalllllllllllllllllllllllllllllllllll") << endl;

  cout << hashStringa2("pippo") << endl;  
  cout << hashStringa2("topolino") << endl;
  cout << hashStringa2("paperino") << endl;
  cout << hashStringa2("paperina") << endl;
  cout << hashStringa2("qui") << endl;  
  cout << hashStringa2("quo") << endl;
  cout << hashStringa2("qua") << endl;

  cout << hashStringa2("qqqqqqqqqqqqwwwwwwwwwwwwwwwwwwwwwwwuuuuuuuuuuuuuuuushggggggggggggmmmmmmmmmmmmmmmkkkkkkkkkkkkkkkkrrrrrrrrrrrrrrrrrrrrrrrrrrrrooooooooooooooooooooooooooosddddddddddddddddddslllllllllllllllllllllaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaammmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmgggggggggggggggggggggggggggmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmaaaaaaaaaaaaaaaaaaaaaaaaaaalllllllllllllllllllllllllllllllllll") << endl;
}    



