// File Prestiti.h
#ifndef PRESTITI_H
#define PRESTITI_H

#include "disco-persona.h"
#include "AlbAVL.h"

/*

  Realizzazione del tipo astratto Prestiti, facendo uso della struttura dati
  Albero di AVL.

  Si assume che l'insieme attributi contenuto negli elementi del dizionario
  coincida con la chiave, che e' un intero.  E' facile modificare questa
  realizzazione, per adattarla a casi piu' generali.

*/


struct rec {
  rec(bool b, Persona* p) { presente = b; info = p; }
  bool presente;
  Persona* info;
};

class Prestiti : private AlbAVL
{public:
  Prestiti(Persona& p) { chi = &p; }
  Persona& Chi() { return *chi; }
  void Inserisci(Disco& d) { AlbAVL::Inserisci(&d, NULL); }
  void Elimina(Disco& d) { AlbAVL::Elimina(&d); }
  rec EstInPrestito(Disco&);
  void Prestato(Disco&, Persona&);
  void Restituito(Disco&);
 private:
  Persona* chi;
  AlbBin* Cerca(Disco*);

  Prestiti(const Prestiti&);
  Prestiti& operator=(const Prestiti&);
};
#endif
