//File Prestiti.cpp

#include <iostream.h>
#include "Prestiti.h"

AlbBin* Prestiti::Cerca(Disco* k)
{
  AlbBin* a = this;
  while (!a->EstVuoto()) {
    if (k < a->Key()) a = a->Sin();
    else if (k > a->Key()) a = a->Des();
    else if (k == a->Key()) return a;
  }
  return NULL;
}


rec Prestiti::EstInPrestito(Disco& d)
{
  AlbBin* r = Cerca(&d);

  if (r == NULL || r->DammiPersona() == NULL)
    return rec(false, NULL);
  else return rec(true, r->DammiPersona());
}

void Prestiti::Prestato(Disco& d, Persona& p)
{
  AlbBin* r = Cerca(&d);

  if (r != NULL && r->DammiPersona() == NULL)
    r->FissaPersona(&p);
}

void Prestiti::Restituito(Disco& d)
{
  AlbBin* r = Cerca(&d);

  if (r != NULL)
    r->FissaPersona(NULL);
}
