// File AlbBin.h
/*

  Realizzazione del tipo astratto (*astrazione di entita'*) corrispondente alla
  struttura dati Albero Binario.  Si noti che l'albero ha figlio sinistro e
  destro in sharing conformemente alla realizzazione dell'HAS-A.

  Le informazioni associate alle radici degli Alberi Binari sono: un Disco e
  una Persona (entrambe in sharing). La persona associata puo' essere cambiata
  attraverso un opportuno metodo FissaPersona. Invece il Disco (che fa da
  chiave) non puo' essere cambiato.

  Si noti che si usa come chiave di un oggetto Disco il suo identificatore,
  cioe' il suo indirizzo.  Questo e' possibile perche sugli indirizzi (cioe'
  puntatori) sono definite tutte le operazini di confronto (==, !=, <, >, <=,
  >=). Questa tecnica e' molto generale e permette di associare in modo
  semplice una chiave a tutti gli oggetti astrazione d'entita'

  (Si noti che la tecnica se applicata a oggetti astrazione per valore da
   risultati scorretti. Perche'?)

*/

#ifndef ALBBIN_H
#define ALBBIN_H

#include "disco-persona.h"

class AlbBin
{public:
  AlbBin();
  AlbBin(Disco*, Persona*, AlbBin*, AlbBin*);
  bool EstVuoto();

  Disco* Key();
  Persona* DammiPersona();
  void FissaPersona(Persona*);
  AlbBin* Sin();
  AlbBin* Des();

 protected:
  bool vuoto;
  Disco* key;    //uso l'idetificatore dell'oggetto disco come chiave
  Persona* info; // Persona in sharing
  AlbBin* sin;
  AlbBin* des;

 private:
  AlbBin(const AlbBin&);
  AlbBin& operator=(const AlbBin&);
};
#endif
