// File AlbAVL.h
/*

  Realizzazione del tipo astratto (*astrazione di entita'*) corrispondente alla
  struttura dati Albero AVL. Si noti che a parte il fatto che Inseresci ed
  Elimina mantengono il bilanciamento dell'albero, tale tipo astratto e'
  identico al tipo astratto per la stuttura dati Albero di Ricerca.
  Si noti che l'albero ha figlio sinistro e destro in sharing conformemente
  alla realizzazione dell'HAS-A.


  Le informazioni associate alle radici degli Alberi Binari sono: un Disco e
  una Persona (entrambe in sharing). La persona associata puo' essere cambiata
  attraverso un opportuno metodo FissaPersona. Invece il Disco (che fa da
  chiave) non puo' essere cambiato.

  Si noti che si usa come chiave di un oggetto Disco il suo identificatore,
  cioe' il suo indirizzo.


*/
#ifndef ALBAVL_H
#define ALBAVL_H

#include "AlbBin.h"

class AlbAVL : public AlbBin
{public:
  AlbAVL() {prf = -1;}   // realizza AlbRicVuoto: () --> AR
  ~AlbAVL();
  void Inserisci(Disco*, Persona*);
  void Elimina(Disco*);

 protected:
  int prf;

  static void aggiornaProfondita(AlbAVL*);
  static void bilancia(AlbAVL*);
  static void rotazioneSS(AlbAVL*);
  static void rotazioneSD(AlbAVL*);
  static void rotazioneDD(AlbAVL*);
  static void rotazioneDS(AlbAVL*);

  static void ins(AlbBin*, Disco*, Persona*);
  static void elim(AlbBin*, Disco*);
  static void elimAux(AlbBin*, AlbBin*);

  static void distruggi(AlbBin*);

 private:
  AlbAVL(const AlbAVL&);
  AlbAVL& operator=(const AlbAVL&);
};
#endif
