// File Dizionario.h
#ifndef DIZ_H
#define DIZ_H

#include "AlbAVL.h"

/*

  Realizzazione del tipo astratto Dizionario, facendo uso della struttura dati
  Albero di AVL.

  Si assume che l'insieme attributi contenuto negli elementi del dizionario
  coincida con la chiave, che e' un intero.  E' facile modificare questa
  realizzazione, per adattarla a casi piu' generali.

*/


struct elem {
  elem(bool b, int i) { presente = b; info = i; }
  bool presente;
  int info;
};

class Dizionario : private AlbAVL
{public:
  Dizionario() {}
  bool EstVuoto() { return AlbAVL::EstVuoto(); }
  void Inserisci(int k) { AlbAVL::Inserisci(k); }
  void Cancella(int k) { AlbAVL::Elimina(k); }
  elem Cerca(int);
  int Min();
  int Max();
  int Succ(int);
  int Pred(int);
 private:
  AlbBin* TrovaKeyPosSucc(AlbBin*,int,AlbBin*&);
  AlbBin* TrovaKeyPosPred(AlbBin*,int,AlbBin*&);
  Dizionario(const Dizionario&);
  Dizionario& operator=(const Dizionario&);
};
#endif
