//File Dizionario.cpp

#include <iostream.h>
#include "Dizionario.h"

elem Dizionario::Cerca(int k)
{
  AlbBin* a = this;
  while (!a->EstVuoto()) {
    if (k < a->Key()) a = a->Sin();
    else if (k > a->Key()) a = a->Des();
    else if (k == a->Key()) return elem(true,a->Key());
  }
  return elem(false, -1);
}

int Dizionario::Min()
{
  if (EstVuoto()) return -1;

  AlbBin* a = this;
  while (!a->Sin()->EstVuoto()) a = a->Sin();
  return a->Key();
}

int Dizionario::Max()
{
  if (EstVuoto()) return -1;

  AlbBin* a = this;
  while (!a->Des()->EstVuoto()) a = a->Des();
  return a->Key();
}


int Dizionario::Succ(int k)
{
  AlbBin* posSucc = NULL;
  AlbBin* a = TrovaKeyPosSucc(this,k,posSucc);
  if (a->EstVuoto()) return -1;

  if (a->Des()->EstVuoto()) { // allora posSucc e' il successore
    if (posSucc != NULL)      // il successore esiste
      return posSucc->Key();
    else return a->Key();     // il successore non esiste
  }
  else {                      // il successore e' nel sottoalbero destro
    a = a->Des();
    while (!a->Sin()->EstVuoto()) a = a->Sin();
    return a->Key();
  }
}


int Dizionario::Pred(int k)
{
  AlbBin* posPred = NULL;
  AlbBin* a = TrovaKeyPosPred(this,k,posPred);
  if (a->EstVuoto()) return -1;

  if (a->Sin()->EstVuoto()) { // allora posPred e' il predecessore
    if (posPred != NULL)      // il predecessore esiste
      return posPred->Key();
    else return a->Key();     // il predecessore non esiste
  }
  else {                      // il predecessore e' nel sottoalbero destro
    a = a->Sin();
    while (!a->Des()->EstVuoto()) a = a->Des();
    return a->Key();
  }
}


AlbBin* Dizionario::TrovaKeyPosSucc(AlbBin* a, int k, AlbBin*& posSucc)
{
  while (!a->EstVuoto()) {
    if (k < a->Key()) {
      posSucc = a; // aggiorna possibile successore
      a = a->Sin();
    }
    else if (k > a->Key())
      a = a->Des();
    else /* (k == a->Key()) */ return a;
  }
  return NULL;
}


AlbBin* Dizionario::TrovaKeyPosPred(AlbBin* a, int k, AlbBin*& posPred)
{
  while (!a->EstVuoto()) {
    if (k < a->Key())
      a = a->Sin();
    else if (k > a->Key()) {
      posPred = a; // aggiorna possibile predecessore
      a = a->Des();
    }
    else /* (k == a->Key()) */ return a;
  }
  return NULL;
}
