// File AlbBin.h
/*

  Realizzazione del tipo astratto (*astrazione di entita'*) corrispondente alla
  struttura dati Albero Binario.  Si noti che l'albero ha figlio sinistro e
  destro in sharing conformemente alla realizzazione dell'HAS-A.

  Si assume che l'informazione contenuta nei nodi coincida con la chiave,
  che e' un intero.  E' facile modificare questa realizzazione, per adattarla a
  casi piu' generali.

*/


#ifndef ALBBIN_H
#define ALBBIN_H

class AlbBin
{public:
  AlbBin();                        // realizza AlbVuoto: () --> AB
  AlbBin(int, AlbBin*, AlbBin*);   // realizza FaiAlb: (info AB, AB) --> AB
  bool EstVuoto();
  int Key();
  AlbBin* Sin();
  AlbBin* Des();

 protected:
  bool vuoto;
  int key;
  AlbBin* sin;
  AlbBin* des;

 private:
  AlbBin(const AlbBin&);
  AlbBin& operator=(const AlbBin&);
};
#endif
