// File AlbAVL.h
/*

  Realizzazione del tipo astratto (*astrazione di entita'*) corrispondente alla
  struttura dati Albero AVL. Si noti che a parte il fatto che Inseresci ed
  Elimina mantengono il bilanciamento dell'albero, tale tipo astratto e'
  identico al tipo astratto per la stuttura dati Albero di Ricerca.
  Si noti che l'albero ha figlio sinistro e destro in sharing conformemente
  alla realizzazione dell'HAS-A.

  Si assume che l'insieme attributi contenuto nei nodi coincida con la chiave
  che e' un intero.  E' facile modificare questa realizzazione, per adattarla a
  casi piu' generali.

*/
#ifndef ALBAVL_H
#define ALBAVL_H
#include "AlbBin.h"

class AlbAVL : public AlbBin
{public:
  AlbAVL() {prf = -1;}   // realizza AlbRicVuoto: () --> AR
  ~AlbAVL();
  void Inserisci(int);
  void Elimina(int);

 protected:
  int prf;

  static void aggiornaProfondita(AlbAVL*);
  static void bilancia(AlbAVL*);
  static void rotazioneSS(AlbAVL*);
  static void rotazioneSD(AlbAVL*);
  static void rotazioneDD(AlbAVL*);
  static void rotazioneDS(AlbAVL*);

  static void ins(AlbBin*, int);
  static void elim(AlbBin*, int);
  static void elimAux(AlbBin*, AlbBin*);

  static void distruggi(AlbBin*);

 private:
  AlbAVL(const AlbAVL&);
  AlbAVL& operator=(const AlbAVL&);
};
#endif
