// File Dizionario.h
#ifndef DIZ_H
#define DIZ_H

#include "AlbRic.h"

/*

  Realizzazione del tipo astratto Dizionario, facendo uso della struttura dati
  Albero di Ricerca.

  Si assume che l'insieme attributi contenuto negli elementi del dizionario
  coincida con la chiave, che e' un intero.  E' facile modificare questa
  realizzazione, per adattarla a casi piu' generali.

*/


struct elem {
  elem(bool b, int i) { presente = b; info = i; }
  bool presente;
  int info;
};

class Dizionario : private AlbRic
{public:
  Dizionario() {}
  bool EstVuoto() { return AlbRic::EstVuoto(); }
  void Inserisci(int k) { AlbRic::Inserisci(k); }
  void Cancella(int k) { AlbRic::Elimina(k); }
  elem Cerca(int);
  int Min();
  int Max();
  int Succ(int);
  int Pred(int);
 private:
  AlbBin* TrovaKeyPosSucc(AlbBin*,int,AlbBin*&);
  AlbBin* TrovaKeyPosPred(AlbBin*,int,AlbBin*&);
  Dizionario(const Dizionario&);
  Dizionario& operator=(const Dizionario&);
};
#endif
