// File AlbRic.h
/*

  Realizzazione del tipo astratto (*astrazione di entita'*) corrispondente alla
  struttura dati Albero di Ricerca.  Si noti che l'albero ha figlio
  sinistro e destro in sharing conformemente alla realizzazione dell'HAS-A.

  Si assume che l'insieme attributi contenuto nei nodi coincida con la chiave
  che e' un intero.  E' facile modificare questa realizzazione, per adattarla a
  casi piu' generali.

*/

#ifndef ALBRIC_H
#define ALBRIC_H
#include "AlbBin.h"

class AlbRic : public AlbBin
{public:
  AlbRic() {}   // realizza AlbRicVuoto: () --> AR
  ~AlbRic();
  void Inserisci(int);
  void Elimina(int);

 protected:
  static void elim(AlbBin*, int);
  static void ins(AlbBin*, int);
  static void distruggi(AlbBin*);

 private:
  AlbRic(const AlbRic&);
  AlbRic& operator=(const AlbRic&);
};
#endif
