#include <iostream.h>
#include "AlbRic.h"



AlbRic::~AlbRic()
{ distruggi(sin); distruggi(des); }

void AlbRic::Inserisci(int k)
{ ins(this, k); }

void AlbRic::ins(AlbBin* a, int k)
{
  if (a->EstVuoto()) {
    AlbRic* ar = (AlbRic*) a;
    ar->vuoto = false;
    ar->key = k;
    ar->sin = new AlbBin();
    ar->des = new AlbBin();
  }
  else if (k < a->Key()) ins(a->Sin(), k);
  else if (k > a->Key()) ins(a->Des(), k);
  else /*(k == a->Key())*/ return;
}

void AlbRic::Elimina(int k)
{ elim(this, k); }

void AlbRic::elim(AlbBin* a, int k)
{
  if (a->EstVuoto()) return;
  if (k < a->Key()) elim(a->Sin(), k);
  else if (k > a->Key()) elim (a->Des(), k);
  else { /*(k == a->Key())*/
    if (a->Des()->EstVuoto()) { //caso 1: figlio des vuoto
      if (a->Sin()->EstVuoto()) {
        delete a->Sin(); // alb vuoto
        delete a->Des();
        AlbRic* ar = (AlbRic*)a;
        ar->vuoto = true;
      }
      else {
        delete a->Des(); // alb vuoto
        AlbBin* aux = a->Sin();
        AlbRic* ar = (AlbRic*)a;
        ar->key = aux->Key();
        ar->sin = aux->Sin();
        ar->des = aux->Des();
        delete aux;
      }
    }
    else if (a->Des()->Sin()->EstVuoto()) {//caso 2a: sin di des vuoto
      AlbBin* aux = a->Des();
      AlbRic* ar = (AlbRic*)a;
      ar->key = aux->Key();
      ar->des = aux->Des();
      delete aux->Sin(); // alb vuoto
      delete aux;
    }
    else { //caso 2b: figlio sin di figlio des non vuoto
      AlbBin* padre = a->Des();
      while (!padre->Sin()->Sin()->EstVuoto()) padre = padre->Sin();
      AlbBin* aux = padre->Sin();
      AlbRic* ar = (AlbRic*)a;
      AlbRic* pr = (AlbRic*)padre;
      ar->key = aux->Key();
      pr->sin = aux->Des();
      delete aux->Sin(); // alb vuoto
      delete aux;
    }
  }
}

void AlbRic::distruggi(AlbBin* a)
{
  if (!a->EstVuoto()) {
    distruggi(a->Sin());
    distruggi(a->Des());
  }
  delete a;
}
