// File main-Albero.cpp
// per il test del modulo Albero
// CC main-Albero.cpp Albero.cpp StampaAlbero.cpp
#include <iostream.h>
#include "Albero.h"

void StampaAlbero(Albero a)
{
  cout << '(';
  if (a.EstVuoto()) {
    cout << ')'; return;
  }
  cout << a.Radice();
  while (!a.Primo().EstVuoto()) {
    StampaAlbero(a.Primo());
    a = a.Resto();
  }
  cout << ')'; 
}


Albero InserisciXultimo(Albero a, Albero b)
{
  // a deve essere non vuoto vuoto
  if (a.Primo().EstVuoto())
    return Albero(a,b);
  else return Albero(InserisciXultimo(a.Resto(),b),a.Primo());
}


Albero Speculare(Albero a)
{
  if (a.EstVuoto())         //alb vuoto
    return a;
  if (a.Primo().EstVuoto()) // solo radice
    return a;
  return InserisciXultimo(Speculare(a.Resto()),Speculare(a.Primo()));
}

Albero Leggialb1()
{
  char c; cin >> c;
  if (c==')')
    return Albero();
  Albero a = Albero(c);
  char d; cin >> d;
  while ( d!=')') {
    a = InserisciXultimo(a,Leggialb1());
    cin >> d;
  }
  return a;
}

Albero LeggiAlbero()
{
  char c; cin >> c; //legge primo '('
  return Leggialb1();
}

void main()
{
  Albero a = Albero('1');
  Albero b = Albero('2');
  a = Albero(a,b);
  StampaAlbero(a);
  cout << endl;
  b = Albero(a,a);
  StampaAlbero(b);
  cout << endl;
  StampaAlbero(Albero(b,b));
  cout << endl;

  Albero c = LeggiAlbero();
  StampaAlbero(c);
  cout << endl;

  StampaAlbero(Speculare(c));
  cout << endl;
}
