// File heap.h
#ifndef HEAP_H
#define HEAP_H

class Heap
{public: 
  Heap();
  Heap(int dimmax);  //heap con dim massima dimmax

  Heap(const Heap&);
  ~Heap();
  Heap& operator=(const Heap&);

  bool EstVuoto();
  int DammiMax();
  void Inserisci(int);
  void EliminaMax();

 protected:
  int* vett; // vettore di interi: la locazione 0 non e' usata
  int dim;   // dimensione del vettore
  int n;     // numero di elementi utilizzati nel vettore

  void FaiSalire(int);
  void FaiScendere(int);
  void Scambia(int, int);  
};

#endif
