// File Visita.cpp

#include "GrafoM.h"
#include "Coda.h"
#include "Pila.h"

//#include "Aggiorna.h"
// contiene void Aggiorna(Grafo&, int);
// che specifica cio' che si fa sul nodo visitato


void VisitaAmpiezza(GrafoM& g, int rad)
{
  g.InizializzaMarche();
  Coda<int> c;
  c.InCoda(rad);
  while (!c.EstVuota()) {
    int i = c.Primo();
    c.OutCoda();
    if (!g.Marcato(i)) {
      g.MettiMarca(i);
      Aggiorna(g,i);
      for (int j = 0; j < g.NumNodi(); j++)
        if (g.EsisteArco(i,j))
          c.InCoda(j);
    }
  }
}

void VisitaProfondita(GrafoM& g, int rad)
{
  g.InizializzaMarche();
  Pila<int> p;
  p.Push(rad);
  while (!p.EstVuota()) {
    int i = p.Top();
    p.Pop();
    if (!g.Marcato(i)) {
      g.MettiMarca(i);
      Aggiorna(g,i);
      for (int j = 0; j < g.NumNodi(); j++)
        if (g.EsisteArco(i,j))
          p.Push(j);
    }
  }
}




