// File PersonaSposata.h
#ifndef PERSONASPOSATA_H
#define PERSONASPOSATA_H
#include "Persona.h"

class PersonaSposata : public Persona
// Classe per la realizzazione del tipo astratto PersonaSposata
// Classe astrazione di entita', derivata da Persona
// Realizzazione con side-effect senza condivisione
{public:
  PersonaSposata(char* nom, char* cog, char* cf, data da, Citta* ci):
    Persona(nom,cog,cf,da,ci) { coniuge = NULL; }        //  costruttore

  void FissaConiuge(PersonaSposata* p) {
    // stabilisce chi e' il coniuge
    // nota : il TA ammette che si possa fissare il coniuge piu' volte
    // se il coniuge attuale e' gia' stato fissato, poni il suo coniuge a null
    if (coniuge != NULL) coniuge->coniuge = NULL;
    coniuge = p;
    // se il coniuge di p  e' gia' stato fissato, poni il suo coniuge a null
    if (p->coniuge != NULL) p->coniuge->coniuge = NULL;
    p->coniuge = this;
  }

  PersonaSposata* Coniuge() { return coniuge; }           // restituisce
                    // l'indirizzo dell'oggetto che rappresenta il coniuge

  void AggiungiAppartamento(const Appartamento& a, bool comproprieta) {
    // aggiunge un appartamento di proprieta';
    // se comproprieta == true, lo aggiunge anche al coniuge
    proprieta.Inserisci(&a);
    if (comproprieta && coniuge != NULL)
      coniuge->proprieta.Inserisci(&a);
  }

 protected:
    PersonaSposata* coniuge; //il coniuge e' in sharing
};
#endif
