// File Persona.h
#ifndef PERSONA_H
#define PERSONA_H
#include "Appartamento.h"
#include "Citta.h"
#include "../Cap05/data.h"
#include "Insieme-SS.h"

class Persona
// Classe per la realizzazione del tipo astratto Persona
// Classe astrazione di entita'
// Realizzazione con side-effect senza condivisione
{ public:
     Persona(char* nom, char* cog, char* cf, data da, Citta* ci):
       cod_fiscale(cf), nato_il(da), nome(nom), nato_a(ci), cognome(cog),
       proprieta(Insieme<Appartamento*>()) {}              // costruttore
     int Eta(data d) { return d.Anno() - nato_il.Anno(); } // restituisce 
                       // l'eta' ricevendo come parametro la data attuale 
     char* CodiceFiscale() { return cod_fiscale; }         // restituisce 
                                                     // il codice fiscale
     char*  Nome() { return nome; }                // restituisce il nome
     char* Cognome() { return cognome; }        // restituisce il cognome
     Citta* CittaNascita() { return nato_a; }              // restituisce 
          // l'indirizzo dell'oggetto che rappresenta la citta di nascita
     Insieme<Appartamento*> AppProprieta(){ return proprieta; }
                                                           // restituisce 
                               // l'insieme di appartamenti di proprieta'
     void  AggiungiAppartamento(const Appartamento& a)
       { proprieta.Inserisci(&a); }                           // aggiunge
                                         // un appartamento di proprieta' 
 protected:
     char*  cod_fiscale;         // codice fiscale
     data   nato_il;             // data di nascita
     char*  nome;                // nome
     char*  cognome;             // cognome
     Citta* nato_a;              // citta di nascita
     Insieme<Appartamento*> proprieta;  // appartamenti di proprieta'
};
#endif
