//pilatemplate.h
#ifndef PILA_H
#define PILA_H
#include <iostream.h>

template<class E>
struct Rec {
  E info;
  Rec* next;
};

template<class Elem>
class Pila {
  friend ostream& operator<<(ostream&, const Pila<Elem>&);
 public:
  Pila();
  ~Pila();
  Pila(const Pila&);
  Pila& operator=(const Pila&);
  bool EstVuota();
  void Push(Elem);
  void Pop();
  Elem Top();
 private:
  Rec<Elem>* testa;
  static Rec<Elem>* Copia(Rec<Elem>*);
  static void Cancella(Rec<Elem>*);
};

#include "pilatemplate.cpp"
//questo, anche se concettualemte "sporco", e' il metodo che funziona meglio
//con i compilatori attuali

#endif
