//pilatemplate.cpp
//#include "pilatemplate.h"
// da includere in "pilatemplate.h"

template<class Elem>
Pila<Elem>::Pila()
{ testa = NULL; }

template<class Elem>
Pila<Elem>::~Pila()
{ Cancella(testa); }

template<class Elem>
Pila<Elem>::Pila(const Pila<Elem>& p)
{ testa = Copia(p.testa); }

template<class Elem>
Pila<Elem>& Pila<Elem>::operator=(const Pila<Elem>& p)
{
  if (this != &p) {
    Cancella(testa);
    testa = Copia(p.testa);
  }
  return *this;
}

template<class Elem>
bool Pila<Elem>::EstVuota()
{ return testa==NULL; }

template<class Elem>
void Pila<Elem>::Push(Elem e)
{
  Rec<Elem>* tmp = new Rec<Elem>;
  tmp->info = e;
  tmp->next = testa;
  testa = tmp;
}

template<class Elem>
void Pila<Elem>::Pop()
{
  Rec<Elem>* tmp = testa;
  testa = testa->next;
  delete tmp;
}

template<class Elem>
Elem Pila<Elem>::Top()
{ return testa->info; }

template<class Elem>
Rec<Elem>* Pila<Elem>::Copia(Rec<Elem>* l)
{
  if (l==NULL) return NULL;
  else {
    Rec<Elem>* ris = new Rec<Elem>;
    ris->info = l->info;
    ris->next = Copia(l->next);
    return ris;
  }
}

template<class Elem>
void Pila<Elem>::Cancella(Rec<Elem>* l)
{
  while (l!=NULL) {
    Rec<Elem>* tmp = l;
    l = l->next;
    delete tmp;
  }
}

template<class Elem>
ostream& operator<<(ostream& os, const Pila<Elem>& p)
{
  Rec<Elem>* l = p.testa;
  while (l != NULL) {
    os << l->info << ' ';
    l = l->next;
  }
  return os;
}

